// 툴팁 요소 생성 함수
function createTooltip() {
  const tooltip = document.createElement('div');
  tooltip.id = 'edunavi-code-tooltip';
  tooltip.style.display = 'none';
  document.body.appendChild(tooltip);
  return tooltip;
}

const tooltip = createTooltip();
let lastCopiedCode = null;

// 구형 방식의 복사 함수 (마우스 오버시 작동 확률을 높임)
function copyToClipboard(text) {
  try {
    const textArea = document.createElement("textarea");
    textArea.value = text;
    
    // 화면 밖으로 숨김 처리
    textArea.style.position = "fixed";
    textArea.style.left = "-9999px";
    textArea.style.top = "0";
    
    document.body.appendChild(textArea);
    textArea.focus();
    textArea.select();
    
    const successful = document.execCommand('copy');
    document.body.removeChild(textArea);
    return successful;
  } catch (err) {
    console.error('Fallback 복사 실패:', err);
    return false;
  }
}

// 마우스가 요소 위로 올라갔을 때
document.addEventListener('mouseover', (event) => {
  const link = event.target.closest('a');
  if (!link || !link.href) return;

  try {
    const url = new URL(link.href);
    const cntntsSn = url.searchParams.get('cntntsSn');

    if (cntntsSn) {
      const code = `E${cntntsSn}`;
      
      // 기본 텍스트 설정
      tooltip.textContent = code;

      // 자동 복사 로직
      if (lastCopiedCode !== code) {
        // execCommand 방식 사용
        const isCopied = copyToClipboard(code);
        
        if (isCopied) {
          tooltip.textContent = `${code} (복사됨)`;
          lastCopiedCode = code;
        } else {
          // 복사 실패시 그냥 코드만 보여줌 (브라우저가 강력 차단한 경우)
          tooltip.textContent = code;
        }
      }
      
      // 툴팁 위치 설정
      const rect = link.getBoundingClientRect();
      const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
      const scrollLeft = window.pageXOffset || document.documentElement.scrollLeft;

      tooltip.style.top = `${rect.top + scrollTop - 35}px`; 
      tooltip.style.left = `${rect.left + scrollLeft}px`;
      tooltip.style.display = 'block';
    }
  } catch (e) {
    return;
  }
});

// 마우스가 요소에서 벗어났을 때
document.addEventListener('mouseout', (event) => {
  const link = event.target.closest('a');
  if (link) {
    tooltip.style.display = 'none';
    lastCopiedCode = null; 
  }
});